
;;Principal Components Example

;;This script does a principal components analysis of the crime data.

;(setf *hide-vista* t)

(setf *demo-data-path* (strcat *default-path* "help\\demos\\datademo\\"))
(unless *princomp-demo-data-loaded*
                  (load-datasets (list "crime.lsp" "p309799.lsp"))
                  (setf *princomp-demo-data-loaded* t))

(principal-components)

(let* ((vis (visualize-model)))
  (defun print-visualization ()
    (send vis :show-window)
    (send vis :front-window)
    (msw-container-print)))

(defun xluser-choice-dialog ()
  (choice-item-dialog nil
   (list ;"Explain These Actions"
         "See Brief Interpretation"
         "See Complete Report" 
         "Save the Analysis"
         "Print the Visualization"
         "See ViSta\'s DeskTop")
   (list ;'(explain-these-actions)
         '(interpret-model) 
         '(report-model)
         '(save-model)
         '(print-visualization)
         '(show-desktop))
   :title "Choose Action"))


(xluser-choice-dialog)

(defmeth pca-model-object-proto :interpret-model ()
  (let* ((evals (send self :eigenvalues))
         (total (sum evals))
         (s (fuzz (* 100 (/ (sum (select evals (iseq 3))) total)) 0))
         (a (fuzz (* 100 (/ (select evals 0) total)) 0))
         (b (fuzz (* 100 (/ (select evals 1) total)) 0))
         (c (fuzz (* 100 (/ (select evals 2) total)) 0))
         (help-window (help (format nil "This visualization shows graphical summaries of your data. The central spinning 3D picture summarizes ~d% of the information in your data ... there is no other 3D picture that can summarize a larger percentage. Similarly, the upper-right graph shows a 2D picture that summarizes ~d% of the information, the largest ammount of information that can be summarized by any 2d picture.~2%Breaking this down, the first dimension summarizes ~d% of the information, the second summarizes ~d%, and the third ~d%.~2%The visualization is based on an analysis of your data called Principal Components Analysis, or PCA for short. PCA summarizes the variation in the variables (the columns) of your data with dimensions which capture more of the variation in your variables than can be captured by any other dimensions which are at right angles to each other.~2%Thus, the first dimension shows the longest dimension through your data, the second is the longest one that is at right angles to the first, etc." s (+ a b) a b c))))
    (send *help-window* :resize)))

;(defun print-interpretation ()
;  (interpret-model :top-most nil)
;  (msw-print))

;(defun print-visualization ()
;  (send *current-spreadplot* :show-window)
;  (msw-print))

;(hide-vista)